CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `dbrecoleccion`.`servicio_reporte` AS
    SELECT 
        `a`.`idservicios` AS `idservicios`,
        `a`.`codigo` AS `codigo`,
        `a`.`estado` AS `estado_servicio`,
        `a`.`numromeses` AS `numromeses`,
        `a`.`idtipo_servicios` AS `idtipo_servicios`,
        `a`.`fecha` AS `fecha_inicio`,
        `a`.`fecha_suspension` AS `fecha_suspension`,
        `a`.`fecha_reconexion` AS `fecha_reconexion`,
        `a`.`fecha_finalizacion` AS `fecha_finalizacion`,
        `b`.`zona` AS `zona`,
        CONCAT(`b`.`nombres`,
                ' ',
                `b`.`apaterno`,
                ' ',
                `b`.`amaterno`) AS `nombre`,
        `b`.`documento` AS `documento`,
        `b`.`telefono` AS `telefono`,
        `c`.`nombre` AS `servicio`,
        `c`.`descripcion` AS `descripcion`,
        `c`.`cantidad_bolsa` AS `cantidad_bolsa`,
        `c`.`valor_servicio` AS `valor_servicio`
    FROM
        ((`dbrecoleccion`.`servicios` `a`
        JOIN `dbrecoleccion`.`persona` `b` ON ((`a`.`idpersona` = `b`.`idpersona`)))
        JOIN `dbrecoleccion`.`tipo_servicios` `c` ON ((`a`.`idtipo_servicios` = `c`.`idtipo_servicios`)))
    ORDER BY `a`.`codigo`